<!DOCTYPE html>
<html lang="en">

<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>

    <title>{{\App\CPU\translate('Product Barcode')}}</title>
    <style>
        @import url("https://fonts.googleapis.com/css2?family=Open+Sans:wght@400;500;600&family=Inter:wght@400;500;600;700;800;900&display=swap");

        @font-face {
            font-family: 'DejaVuSans';
            src: url('../public/assets/admin/font/ttf/DejaVuSans.ttf');
        }

        .text-capitalize {
            text-transform: uppercase;
        }

        .text-bold {
            font-weight: bold;
        }

        body {
            font-family: "Inter", serif;
            font-optical-sizing: auto;
            font-weight: 400;
            font-style: normal;
            font-size: 0.875rem;
        }

        /*.currency {*/
        /*    font-family: "DejaVuSans";*/
        /*}*/

        * {
            margin: 0;
            padding: 0;
        }

        /* General table styling */
        .product-table {
            width: 100%;
            border-spacing: 10px;
        }

        .table-row {
            width: 100%;
        }

        /* Styling for the first column */
        .product-info {
            text-align: center;
            border: 1px dotted #ccc;
            padding: 12px;
        }

        /* Styling for the text and barcode */
        .shop-name {
            font-weight: bold;
            text-transform: capitalize;
        }

        .product-name, .currency, .product-code {
            display: block;
            text-align: center;
        }

        .barcode-container {
            display: inline-block;
            text-align: center;
        }

        .mb-2 {
            margin-bottom: 8px;
        }

        .mb-1 {
            margin-bottom: 4px;
        }


    </style>
</head>

<body>
@if ($quantity)
    <table class="product-table">
        @for ($i = 0; $i < $quantity; $i++)
            @if ($i % 3 == 0)
                <tr class="table-row">
                    @endif

                    <td class="product-info">
                        <div
                            class="shop-name mb-2 text-capitalize text-bold">{{ \App\Models\BusinessSetting::where('key', 'shop_name')->first()->value }}</div>
                        <div class="product-name ">{{ Str::limit($product->name, 30) }}</div>
                        <div class="currency mb-1 text-bold">
                            {{ $product['selling_price'] . ' ' . \App\CPU\Helpers::currency_symbol() }}
                        </div>
                        <div class="barcode-container ">
                            {!! DNS1D::getBarcodeHTML($product->product_code, 'C128') !!}
                        </div>
                        <div class="product-code">{{ $product->product_code }}</div>
                    </td>

                    @if (($i + 1) % 3 == 0 || $i + 1 == $quantity) <!-- Check if it's the last item in the row -->
                </tr>
            @endif
        @endfor
    </table>
@endif
</body>
</html>
