@php
use function App\CPU\translate;
use App\CPU\Helpers;
@endphp
<div class="modal fade" id="order_refund_modal" tabindex="-1" aria-modal="true" role="dialog">
    <div class="modal-dialog modal-dialog-centered modal-lg modal-dialog-scrollable custom-scrollable">
        <div class="modal-content">
            <div class="modal-header p-3 border-bottom">
                <h5 class="modal-title text-center flex-grow-1">{{ translate('Order Refund') }}</h5>
                <button type="button" class="btn btn-soft-secondary px-1 py-0 rounded-circle" data-dismiss="modal"
                        aria-label="Close">
                        <span aria-hidden="true">
                            <i class="tio-clear"></i>
                        </span>
                </button>
            </div>
            <form action="{{ route('admin.order.refund', $order?->id) }}" method="POST" id="">
                @csrf
                <div class="modal-body">
                    <div class="bg-light rounded-10 p-4">
                        <div class="form-group">
                            <label
                                class="input-label font-weight-medium text-capitalize">{{ translate('Refund Amount') }} ({{ Helpers::currency_symbol() }}) <small class="text-danger">*</small></label>

                            <input type="number" name="refund_amount" class="form-control h-44px"
                                   value="{{ $order?->order_amount + $order?->total_tax - ($order?->coupon_discount_amount ?? 0) - ($order?->extra_discount ?? 0) }}"
                                   placeholder="{{ '$' . $order?->order_amount + $order?->total_tax - ($order?->coupon_discount_amount ?? 0) - ($order?->extra_discount ?? 0) }}">
                        </div>

                        <div class="form-group character-count">
                            <label
                                class="input-label font-weight-medium text-capitalize">{{ translate('Refund Cause') }}</label>
                            <textarea class="form-control character-count-field" name="refund_reason" id=""
                                      cols="30" rows="5" maxlength="100" data-max-character="100"
                                      placeholder="Type refund note"></textarea>
                            <p class="text-end text-black-50 mb-0">{{ translate('0/100') }}</p>
                        </div>
                    </div>
                </div>
                <div class="modal-footer border-0">
                    <div class="d-flex gap-3 justify-content-end">
                        <button type="reset" class="btn btn-soft-danger px-4 font-weight-bold min-w-94px"
                                data-dismiss="modal">Cancel
                        </button>
                        <button type="submit"
                                class="btn btn-primary px-4 font-weight-bold min-w-94px submit-refund-form">Submit
                        </button>
                    </div>
                </div>
                <input type="hidden" name="payment_via" value="">
                <input type="hidden" name="max_amount" value="{{ $order?->order_amount + $order?->total_tax }}">
            </form>
        </div>
    </div>
</div>
