<?php
$cardId = session('current_user');
$cardName = $cardId ? session($cardId) : null;
?>

<div id="product-id-{{ $product->id }}" class="">
    <input type="hidden" id="product_id" name="id" value="{{ $product->id }}">
    <input type="hidden" id="product_qty" name="quantity" value=1>
    <div class="pos-product-item @if ($cardName && in_array($product->id, array_column($cardName, 'id'))) active @endif" id="single-product-card-{{$product->id}}">
        <div class="pos-product-item_thumb single-cart-data" data-id="{{ $product->id }}">
            <img src="{{$product['image_fullpath']}}" class="img-fit">
            @php($index = !empty($cardName) ? array_search($product->id, array_column($cardName, 'id')) : false)
            <div class="hover-content">
                <div class="counter-container increment-decrement-section" data-id="{{ $product->id }}">
                    <button class="btn-decrement btn-number" data-type="minus" data-field="quantity">-</button>
                    @if ($index !== false)
                        <input type="number" name="quantity" id="quantity" value="{{ $cardName[$index]['quantity'] }}" min="1" max="100"
                                data-key="{{ $index }}" class="counter-input qty-width single_card_input_{{$product->id}}">
                    @else
                        <input type="number"
                                name="quantity" id="quantity" value="0" min="1" max="100"
                                data-key="-1" class="counter-input qty-width single_card_input_{{$product->id}}" disabled>
                    @endif
                    <button class="btn-increment btn-number" data-type="plus" data-field="quantity">+</button>
                </div>
            </div>
            <div class="hover-content-text">
                <div class="text">
                    {{ \App\CPU\translate('Add to Cart') }}
                </div>
            </div>
        </div>
        <div class="pos-product-item_content">
            <div class="pos-product-item_title pos-single-product-card" data-id="{{$product->id}}">{{ $product['name'] }}</div>
            <div class="pos-product-item_price">
                @if($product->discount > 0)
                    <div class="fz-10 text-muted text-decoration">
                        {{ $product['selling_price'] . ' ' . \App\CPU\Helpers::currency_symbol() }}
                    </div>
                @endif
                <div>
                    {{ ($product['selling_price']- \App\CPU\Helpers::discount_calculate($product, $product['selling_price'])) . ' ' . \App\CPU\Helpers::currency_symbol() }}
                </div>
            </div>
        </div>
    </div>
</div>


