@extends('layouts.admin.app')

@section('title', \App\CPU\translate('counter edit'))

@push('css_or_js')
    <link rel="stylesheet" href="{{ asset('public/assets/admin') }}/css/custom.css" />
@endpush

@section('content')
    <div class="content container-fluid">
        <div class="">
            <div class="row align-items-center mb-3 ">
                <div class="col-sm mb-2 mb-sm-0">
                    <h1 class="page-header-title text-capitalize fs-16">
                        <span>{{ \App\CPU\translate('counter edit') }}</span>
                    </h1>
                </div>
            </div>
        </div>
        <div class="card">
            <div class="card-body">
                <form action="{{ route('admin.counter.update', $counter['id']) }}" method="post">
                    @csrf
                    <div class="row pl-2">
                        <div class="col-12 col-sm-6">
                            <div class="form-group mb-3">
                                <label class="input-label font-weight-medium text-capitalize" for="name">{{ \App\CPU\translate('Counter_Name') }}</label>
                                <input type="text" name="name" class="form-control" value="{{ $counter->name }}"  maxlength="255" required>
                            </div>
                            <div class="form-group mb-3">
                                <label class="input-label font-weight-medium text-capitalize" for="number">{{ \App\CPU\translate('Counter_number') }}</label>
                                <input type="text" name="number" class="form-control" value="{{ $counter->number }}" required>

                            </div>
                        </div>
                        <div class="col-12 col-sm-6">
                            <div class="form-group mb-3">
                                <label class="input-label font-weight-medium text-capitalize" for="description">{{ \App\CPU\translate('Short_Description') }}</label>
                                <textarea class="form-control" name="description" id="" cols="30" rows="5" maxlength="255" required>{{ $counter->description }}</textarea>
                            </div>
                        </div>
                    </div>
                    <div class="d-flex justify-content-end pt-1">
                        <button type="submit" class="btn btn-primary min-w-80px">{{ \App\CPU\translate('update') }}</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
@endsection

@push('script_2')

@endpush
