@extends('layouts.admin.app')

@section('title', \App\CPU\translate('order_details'))

@section('content')
    <div class="content container-fluid">
        <h1 class="page-header-title text-capitalize mb-3">
            Order Details
        </h1>
        <div class="row g-2">
            <div class="col-lg-8">
                <div class="card mb-3">
                    <div class="card-body p-3">
                        <div class="d-flex gap-3 flex-wrap justify-content-between align-items-center mb-4">
                            <div class="flex-grow-1">
                                <h3 class="text-primary fw-bold">ID #000001</h3>
                                <h6><span class="text-black-50">Date :</span> 05 Dec 2023,
                                    <span class="font-weight-normal"> 4:30 PM</span>
                                </h6>
                            </div>
                            <div class="d-flex gap-10 flex-wrap flex-grow-1 flex-lg-grow-0">
                                <button class="btn btn-white text-primary flex-grow-1" type="button" data-toggle="modal"
                                    data-target="#order_refund_modal">
                                    Refund Order
                                </button>
                                <button
                                    class="btn btn-white text-primary flex-grow-1 d-flex gap-2 align-items-center justify-content-center"
                                    type="button">
                                    Edit
                                    <i class="tio-edit"></i>
                                </button>
                                <button
                                    class="btn btn-primary flex-grow-1 d-flex gap-2 align-items-center justify-content-center"
                                    type="button">
                                    Print
                                    <i class="tio-print"></i>
                                </button>
                            </div>
                        </div>
                        <div class="row g-3">
                            <div class="col-md-6">
                                <div class="bg-light h-100">
                                    <div class="p-3">
                                        <h5 class="text-uppercase mb-0">Order Info</h5>
                                    </div>
                                    <hr class="m-0">
                                    <div class="p-3">
                                        <h6 class="d-flex gap-3 mb-3">
                                            <span class="min-w-120px d-flex gap-2 align-items-center">
                                                <span class="text-black-50">
                                                    <img class="svg"
                                                        src="{{ asset('public/assets/admin/img/counter.svg') }}"
                                                        alt="">
                                                </span>
                                                <span>Counter No</span>
                                            </span>
                                            <span class="d-flex align-items-center gap-3">:
                                                <span>Counter - 1001 (south corner counter)</span></span>
                                        </h6>
                                        <h6 class="d-flex gap-3 mb-3">
                                            <span class="min-w-120px d-flex gap-2 align-items-center">
                                                <span class="text-black-50">
                                                    <img class="svg"
                                                        src="{{ asset('public/assets/admin/img/administrator.svg') }}"
                                                        alt="">
                                                </span>
                                                <span> Placed By</span>
                                            </span>
                                            <span class="d-flex align-items-center gap-3">: <span>Alexander
                                                    Daniel</span></span>
                                        </h6>
                                        <h6 class="d-flex gap-3 mb-0">
                                            <span class="min-w-120px d-flex gap-2 align-items-center">
                                                <span class="text-black-50">
                                                    <img class="svg"
                                                        src="{{ asset('public/assets/admin/img/lists.svg') }}"
                                                        alt="">
                                                </span>
                                                <span> Order Status</span>
                                            </span>
                                            <span class="d-flex align-items-center gap-3">: 
                                                {{-- <span class="badge badge-soft-success px-2 py-1 rounded-full">Completed</span> --}}
                                                <span class="badge badge-soft-danger px-2 py-1 rounded-full">Refunded</span>
                                            </span>
                                        </h6>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="bg-light h-100">
                                    <div class="p-3">
                                        <h5 class="text-uppercase mb-0">Payment Info</h5>
                                    </div>
                                    <hr class="m-0">
                                    <div class="p-3">
                                        <h6 class="d-flex gap-3 mb-3">
                                            <span class="min-w-120px">
                                                <span>Reference ID</span>
                                            </span>
                                            <span class="d-flex align-items-center gap-3">: <span>1002345</span></span>
                                        </h6>
                                        <h6 class="d-flex gap-3 mb-3">
                                            <span class="min-w-120px">
                                                <span>Payment Method</span>
                                            </span>
                                            <span class="d-flex align-items-center gap-3">:
                                                <span class="d-flex align-items-center gap-2 flex-wrap">
                                                    <span class="badge badge-soft-success px-2 py-1 rounded-full">Cash</span>
                                                    <span class="badge badge-soft-success-dark px-2 py-1 rounded-full">Wallet</span>
                                                </span>
                                            </span>
                                        </h6>
                                        <h6 class="d-flex gap-3 mb-0">
                                            <span class="min-w-120px">
                                                <span>Payment Status</span>
                                            </span>
                                            <span class="d-flex align-items-center gap-3">: <span
                                                    class="badge badge-soft-warning px-2 py-1 rounded-full">Paid</span>
                                            </span>
                                        </h6>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="bg-light rounded py-3 px-3 mt-3">
                            <h6 class="d-flex gap-2 mb-0">
                                <span class="text-primary text-nowrap"> # Note: </span>
                                <span class="font-weight-normal">Please provide extra layer in the packaging</span>
                            </h6>
                        </div>
                    </div>
                </div>
                <div class="card">
                    <div class="card-body p-3">
                        <h5 class="mb-10px text-uppercase">Item Summary</h5>
                        <div class="table-responsive">
                            <table
                                class="table table-hover table-thead-bordered table-nowrap table-align-middle card-table mb-0">
                                <thead class="thead-light">
                                    <tr>
                                        <th>SL</th>
                                        <th>Item details</th>
                                        <th class="text-center">Qty</th>
                                        <th class="text-center">Vat/Tax</th>
                                        <th class="text-center">Discount</th>
                                        <th class="text-right">Total</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td>
                                            1
                                        </td>
                                        <td>
                                            <div class="media">
                                                <div class="avatar mr-2">
                                                    <img width="40" height="40" class="avatar-img onerror-image"
                                                        data-onerror-image="{{ asset('public/assets/admin/img/160x160/img2.jpg') }}"
                                                        src="{{ asset('public/assets/admin/img/160x160/img2.jpg') }}"
                                                        alt="Image Description">
                                                </div>
                                                <div class="media-body">
                                                    <h6 class="line-limit-1 mb-1 text-wrap min-w-190px">
                                                        <a href="#">
                                                            Black Driver Club Leather Loafer Men shoe
                                                        </a>
                                                    </h6>
                                                    <h6 class="mb-1"><span class="text-black-50">Purchase Price :</span>
                                                        $
                                                        90</h6>
                                                    <h6 class="mb-1"><span class="text-black-50">Variation :</span>
                                                        Black-
                                                        40</h6>
                                                </div>
                                            </div>
                                        </td>
                                        <td class="text-center">
                                            <h6>1</h6>
                                        </td>
                                        <td class="text-center">
                                            <h6>$ 10</h6>
                                        </td>
                                        <td class="text-center">
                                            <h6>$ 0.00</h6>
                                        </td>
                                        <td class="text-right">
                                            <h6>$ 120.00</h6>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            2
                                        </td>
                                        <td>
                                            <div class="media">
                                                <div class="avatar mr-2">
                                                    <img width="40" height="40" class="avatar-img onerror-image"
                                                        data-onerror-image="{{ asset('public/assets/admin/img/160x160/img2.jpg') }}"
                                                        src="{{ asset('public/assets/admin/img/160x160/img2.jpg') }}"
                                                        alt="Image Description">
                                                </div>
                                                <div class="media-body">
                                                    <h6 class="line-limit-1 mb-1 text-wrap min-w-190px">
                                                        <a href="#">
                                                            Black Driver Club Leather Loafer Men shoe
                                                        </a>
                                                    </h6>
                                                    <h6 class="mb-1"><span class="text-black-50">Purchase Price :</span>
                                                        $
                                                        90</h6>
                                                    <h6 class="mb-1"><span class="text-black-50">Variation :</span>
                                                        Black
                                                        - 40</h6>
                                                </div>
                                            </div>
                                        </td>
                                        <td class="text-center">
                                            <h6>1</h6>
                                        </td>
                                        <td class="text-center">
                                            <h6>$ 10</h6>
                                        </td>
                                        <td class="text-center">
                                            <h6>$ 0.00</h6>
                                        </td>
                                        <td class="text-right">
                                            <h6>$ 120.00</h6>
                                        </td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                        <div class="mx-3">
                            <hr>
                        </div>
                        <div class="row justify-content-md-end mx-0">
                            <div class="col-12">
                                <h5 class="mb-0 text-uppercase">Billing Summary</h5>
                            </div>
                            <div class="col-lg-6">
                                <dl class="row pt-2 pt-lg-0 g-lg-0">
                                    <dt class="col-6 font-weight-normal">Subtotal</dt>
                                    <dd class="col-6 h5 text-end">
                                        $ 360
                                    </dd>
                                    <dt class="col-6 font-weight-normal">Discount (10%)</dt>
                                    <dd class="col-6 text-end">
                                        - $ 10.00
                                    </dd>
                                    <dt class="col-6 font-weight-normal">Extra Discount ($)</dt>
                                    <dd class="col-6 text-end">
                                        - $ 0.00
                                    </dd>
                                    <dt class="col-6 font-weight-normal">Coupon Discount ($)</dt>
                                    <dd class="col-6 text-end">
                                        - $ 0.00
                                    </dd>
                                    <dt class="col-6 font-weight-normal">Vat/Tax</dt>
                                    <dd class="col-6 text-end">
                                        + $ 5.00
                                    </dd>

                                    <dd class="col-12 border-top-dashed mt-2 mb-4"></dd>

                                    <dt class="col-6 h4">Total</dt>
                                    <dd class="col-6 text-end h4">$ 360.00</dd>
                                    <dt class="col-6 font-weight-normal">Cash</dt>
                                    <dd class="col-6 text-end">$ 400.00</dd>
                                    <dt class="col-6 h4">Paid</dt>
                                    <dd class="col-6 text-end h4">$ 400.00</dd>
                                    <dt class="col-6 font-weight-normal">Change Amount</dt>
                                    <dd class="col-6 text-end">$ 45.00</dd>
                                </dl>
                                <!-- End Row -->
                            </div>
                        </div>
                        <!-- End Row -->
                    </div>
                </div>

            </div>
            <div class="col-lg-4">
                <div class="row g-2">
                    <div class="col-lg-12 col-md-6">
                        <div class="card mt-2">
                            <div class="card-header d-flex flex-wrap align-items-center border-0 m-2">
                                <h5 class="card-title">
                                    Customer Details
                                </h5>
                                <h6><span class="font-weight-normal">Total Orders</span> <span
                                        class="badge badge-danger rounded-full ml-1">4</span></h6>
                            </div>
                            <div class="card-body pt-0">
                                <div class="d-flex flex-column gap-3">
                                    <div class="media flex-column gap-3 bg-light rounded p-4">
                                        <div class="avatar avatar-circle avatar-lg">
                                            <img width="50" height="50" class="avatar-img onerror-image"
                                                data-onerror-image="{{ asset('public/assets/admin/img/160x160/img1.jpg') }}"
                                                src="{{ asset('public/assets/admin/img/160x160/img1.jpg') }}"
                                                alt="Image Description">
                                        </div>
                                        <div class="media-body d-flex flex-column gap-3">
                                            <a href="#" class="d-flex align-items-center">
                                                <i class="tio-user mr-2"></i>
                                                <span>Jonathan Kohl</span>
                                            </a>
    
                                            <a href="#" class="d-flex align-items-center">
                                                <i class="tio-call-talking-quiet mr-2"></i>
                                                <span> +8801700000000</span>
                                            </a>
    
                                            <a href="#" class="d-flex align-items-center">
                                                <i class="tio-email-outlined mr-2"></i>
                                                <span>deliveryman@6amtech.com</span>
                                            </a>
                                            <a href="#" class="d-flex align-items-center">
                                                <i class="tio-city mr-2"></i>
                                                <span>New York</span>
                                            </a>
                                            <a href="#" class="d-flex align-items-center">
                                                <img class="svg mr-2" src="{{ asset('public/assets/admin/img/zipcode.svg') }}"
                                                    alt="">
                                                <span>10001</span>
                                            </a>
                                            <a href="#" class="d-flex align-items-center">
                                                <i class="tio-poi mr-2"></i>
                                                <span>41 Gower Street, St Georg, TF2 9BL</span>
                                            </a>
    
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-12 col-md-6">
                        <div class="card mt-2">
                            <div class="card-header d-flex flex-wrap align-items-center border-0 m-2">
                                <h5 class="card-title">
                                    Employee Details
                                </h5>
                            </div>
                            <div class="card-body pt-0">
                                <div class="d-flex flex-column gap-3">
                                    <div class="media flex-column gap-3 bg-light rounded p-4">
                                        <div class="avatar avatar-circle avatar-lg">
                                            <img width="50" height="50" class="avatar-img onerror-image"
                                                data-onerror-image="{{ asset('public/assets/admin/img/160x160/img1.jpg') }}"
                                                src="{{ asset('public/assets/admin/img/160x160/img1.jpg') }}"
                                                alt="Image Description">
                                        </div>
                                        <div class="media-body d-flex flex-column gap-3">
                                            <a href="#" class="d-flex align-items-center">
                                                <i class="tio-user mr-2"></i>
                                                <span>Jonathan Kohl</span>
                                            </a>
    
                                            <a href="#" class="d-flex align-items-center">
                                                <i class="tio-call-talking-quiet mr-2"></i>
                                                <span> +8801700000000</span>
                                            </a>
    
                                            <a href="#" class="d-flex align-items-center">
                                                <i class="tio-email-outlined mr-2"></i>
                                                <span>deliveryman@6amtech.com</span>
                                            </a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    {{-- Order Refund Modal --}}
    <div class="modal fade" id="order_refund_modal" tabindex="-1" aria-modal="true" role="dialog">
        <div class="modal-dialog modal-dialog-centered modal-lg modal-dialog-scrollable custom-scrollable">
            <div class="modal-content">
                <div class="modal-header p-3 border-bottom">
                    <h5 class="modal-title text-center flex-grow-1">Order Refund</h5>
                    <button type="button" class="btn btn-soft-secondary px-1 py-0 rounded-circle" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">
                            <i class="tio-clear"></i>
                        </span>
                    </button>
                </div>
                <form action="" method="post" id="">
                    <div class="modal-body">
                        <div class="bg-light rounded-10 p-4">
                            <div class="form-group">
                                <label class="input-label font-weight-medium text-capitalize">Refund Amount</label>
                                <input type="text" name="" class="form-control h-44px" value=""
                                    placeholder="$ 355.00">
                            </div>
    
                            <div class="form-group">
                                <label class="input-label font-weight-medium text-capitalize">Refund Cause</label>
                                <textarea class="form-control" name="" id="" cols="30" rows="5" maxlength="100" placeholder="Type refund note"></textarea>
                                <p class="text-end text-black-50 mb-0">0/100</p>
                            </div>
    
                            <div class="card p-4">
                                <label class="input-label font-weight-medium text-capitalize">Payment Via</label>
    
                                <div class="d-flex flex-wrap gap-2 align-items-center">
                                    <!-- Tab navigation -->
                                    <div class="nav nav-pills refund-tabs gap-10 align-items-center">
                                        <a class="nav-link px-3 py-2 active" id="cash-tab" data-toggle="pill" href="#cash">Cash</a>
                                        <a class="nav-link px-3 py-2" id="card-tab" data-toggle="pill" href="#card">Card</a>
                                        <a class="nav-link px-3 py-2" id="mobile-banking-tab" data-toggle="pill" href="#mobile-banking">Mobile Banking</a>
                                        <a class="nav-link px-3 py-2" id="wallet-tab" data-toggle="pill" href="#wallet">Wallet</a>
                                        <a class="nav-link px-3 py-2" id="bank-tab" data-toggle="pill" href="#bank">Bank</a>
                                    </div>
                                </div>
                                
                                <!-- Tab content -->
                                <div class="tab-content">
                                    <div class="tab-pane fade show active" id="cash">
                                    </div>
                                    <div class="tab-pane fade mt-4" id="card">
                                        <div class="form-group mb-0">
                                            <label class="input-label font-weight-medium text-capitalize">Card No</label>
                                            <input type="text" name="" class="form-control h-44px" value=""
                                                placeholder="Ex: 0000-0000-0000">
                                        </div>
                                    </div>
                                    <div class="tab-pane fade mt-4" id="mobile-banking">
                                        <div class="form-group mb-3">
                                            <label class="input-label font-weight-medium text-capitalize">Mobile Banking Type</label>
                                            <input type="text" name="" class="form-control h-44px" value=""
                                                placeholder="Ex: Bkash">
                                        </div>
                                        <div class="form-group mb-0">
                                            <label class="input-label font-weight-medium text-capitalize">Phone No</label>
                                            <input type="tel" name="" class="form-control h-44px" value=""
                                                placeholder="Ex: 01234567890">
                                        </div>
                                    </div>
                                    <div class="tab-pane fade mt-4" id="wallet">
                                        <div class="form-group mb-0">
                                            <label class="input-label font-weight-medium text-capitalize">Phone No or Email</label>
                                            <input type="text" name="" class="form-control h-44px" value=""
                                                placeholder="Ex: 0987654321 / acb@gmail.com">
                                        </div>
                                    </div>
                                    <div class="tab-pane fade mt-4" id="bank">
                                        <div class="form-group mb-0">
                                            <label class="input-label font-weight-medium text-capitalize">Bank A/C Number</label>
                                            <input type="text" name="" class="form-control h-44px" value=""
                                                placeholder="Ex: 0000  0000 0000 ">
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer border-0">
                            <div class="d-flex gap-3 justify-content-end">
                                <button type="reset" class="btn btn-soft-danger px-4 font-weight-bold min-w-94px"
                                    data-dismiss="modal">Cancel</button>
                                <button type="submit" class="btn btn-primary px-4 font-weight-bold min-w-94px">Submit</button>
                            </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
@endsection

@push('script_2')
    <script>
        "use strict";

        $(function() {
            /*=====================
                Changing svg color
                ========================*/
            $("img.svg").each(function() {
                var $img = jQuery(this);
                var imgID = $img.attr("id");
                var imgClass = $img.attr("class");
                var imgURL = $img.attr("src");

                jQuery.get(
                    imgURL,
                    function(data) {
                        // Get the SVG tag, ignore the rest
                        var $svg = jQuery(data).find("svg");

                        // Add replaced image's ID to the new SVG
                        if (typeof imgID !== "undefined") {
                            $svg = $svg.attr("id", imgID);
                        }
                        // Add replaced image's classes to the new SVG
                        if (typeof imgClass !== "undefined") {
                            $svg = $svg.attr("class", imgClass + " replaced-svg");
                        }

                        // Remove any invalid XML tags as per http://validator.w3.org
                        $svg = $svg.removeAttr("xmlns:a");

                        // Check if the viewport is set, else we gonna set it if we can.
                        if (
                            !$svg.attr("viewBox") &&
                            $svg.attr("height") &&
                            $svg.attr("width")
                        ) {
                            $svg.attr(
                                "viewBox",
                                "0 0 " + $svg.attr("height") + " " + $svg.attr("width")
                            );
                        }

                        // Replace image with new SVG
                        $img.replaceWith($svg);
                    },
                    "xml"
                );
            });
        });
    </script>
@endpush
