<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width">
    <title>{{\App\CPU\translate('Add to cart page')}}</title>
    @php($favIcon=\App\Models\BusinessSetting::where(['key'=>'fav_icon'])->first()->value)
    <link rel="shortcut icon" href="{{asset('storage/app/public/shop').'/' . $favIcon }}">
    <link rel="stylesheet" href="{{ asset('public/assets/admin') }}/vendor/icon-set/style.css">
    <link rel="stylesheet" href="{{ asset('public/assets/admin') }}/flaticon-font/css/uicons-regular-rounded.css">
    <link rel="stylesheet" href="{{ asset('public/assets/admin') }}/flaticon-font/css/uicons-solid-rounded.css">
    <link rel="stylesheet" href="{{asset('public/assets/admin')}}/css/google-fonts.css">
    <link rel="stylesheet" href="{{asset('public/assets/admin')}}/css/vendor.min.css">
    <link rel="stylesheet" href="{{asset('public/assets/admin')}}/plugins/swiper.min.css">
    <link rel="stylesheet" href="{{asset('public/assets/admin')}}/css/theme.minc619.css?v=1.0">
    @stack('css_or_js')
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <link rel="stylesheet" href="{{asset('public/assets/admin')}}/css/custom.css"/>
    <link rel="stylesheet" href="{{asset('public/assets/admin')}}/css/pos.css"/>
    <link rel="stylesheet" href="{{ asset('public/assets/admin') }}/css/custom-2.css" />
    <link rel="stylesheet" href="{{asset('public/assets/admin')}}/css/toastr.css">

    <style>
        .text-decoration{
            text-decoration: line-through;
        }
    </style>

    <script defer>
        document.addEventListener('DOMContentLoaded', function() {

            function isMiniSidebarHandle() {
                if (!localStorage.getItem('isMiniSidebar')) {
                    $("body").addClass('footer-offset m-0 footer-offset has-navbar-vertical-aside navbar-vertical-aside-show-xl navbar-vertical-aside-mini-mode');
                } else {
                    $("body").addClass('footer-offset m-0 footer-offset has-navbar-vertical-aside navbar-vertical-aside-show-xl');
                }
            }
            isMiniSidebarHandle();
        });
    </script>
</head>
<body class="footer-offset navbar-vertical-aside-mini-mode m-0">
    <div class="direction-toggle">
        <i class="tio-settings"></i>
        <span></span>
    </div>
    <div class="container">
        <div class="row">
            <div class="col-md-12">
                <div id="loading" class="d-none">
                    <div class="style-i1">
                        <img width="200" src="{{asset('public/assets/admin/img/loader.gif')}}" alt="{{\App\CPU\translate('loader gif')}}">
                    </div>
                </div>
            </div>
        </div>
    </div>

    @include('layouts.admin.partials._header')
    @include('layouts.admin.partials._sidebar')

    <main id="content" role="main" class="main pointer-event">
        <section class="section-content pt-2">
            <div class="container-fluid px-3">
                <div class="d-flex flex-wrap gap-2">
                    <div class="order--pos-left gap-2">
                        <div class="card">
                            <div class="card-header pb-0 border-0 px-3">
                                <h4 class="m-0">Search or Scan</h4>
                                <div class="text-dark">
                                    {{ \App\CPU\translate('Product isn’t in the List') }}? <a href="{{ route('admin.product.add') }}" target="_blank" class="text-danger">{{ \App\CPU\translate('Add New') }}<i class="tio-add"></i></a>
                                </div>
                            </div>
                            <div class="card-body p-3 pt-2">
                                <div class="d-flex flex-wrap gap-3">
                                    <div class="input-group-overlay input-group-merge input-group-custom flex-grow-1">
                                        <div class="input-group-prepend">
                                            <div class="input-group-text">
                                                <i class="tio-search"></i>
                                            </div>
                                        </div>
                                        <input id="search" autocomplete="off" type="text" name="search"
                                            class="form-control search-bar-input pos-search"
                                            placeholder="{{\App\CPU\translate('Search product  name or scan barcode')}}"
                                            aria-label="Search here" >
                                        <diV class="pos-search-card w-4 position-absolute z-index-1 w-100">
                                            <div id="search-box" class="card card-body search-result-box d--none p-2"></div>
                                        </diV>
                                    </div>
                                    <div class="d-flex flex-end position-relative show-filter-count">
                                        <button class="btn btn-white" type="button" id="filterMenuToggle" aria-controls="offcanvasFilterMenu" aria-expanded="false" aria-label="Toggle filter menu">
                                            {{\App\CPU\translate('Filters')}}
                                            <i class="tio-filter-list"></i>
                                            </button>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="card flex-grow-1">
                            <div class="card-body d-flex flex-column px-2 py-3" id="items">
                                @if(count($products)==0)
                                    <div class="text-center p-4 d-flex flex-column justify-content-center align-items-center flex-grow-1">
                                        <img class="mb-3 w-i5" src="{{asset('public/assets/admin')}}/svg/illustrations/sorry.svg" alt="{{\App\CPU\translate('Image Description')}}" >
                                        <p class="mb-0">{{ \App\CPU\translate('No_data_to_show')}}</p>
                                    </div>
                                @else
                                    <div class="pos-item-wrap">
                                        @foreach($products as $product)
                                            @include('admin-views.pos._single_product',['product'=>$product])
                                        @endforeach
                                    </div>
                                @endif

                                <div class="table-responsive mt-3">
                                    <div class="px-4 d-flex justify-content-lg-end">
                                        {!!$products->withQueryString()->links()!!}
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    @php($customers = \App\Models\Customer::get())
                    <div class="order--pos-right">
                        <div class="card billing-section-wrap">
                            <div class="billing-section-wrap-title">
                                <h4 class="p-3 bg-light text-center">{{\App\CPU\translate('Billing_Section')}}</h4>
                            </div>
                            <div>
                                <div class="card-body pt-1">
                                        <div class="mb-3">
                                            <label class="input-label font-weight-medium text-capitalize">{{ \App\CPU\translate('counter number') }}</label>
                                            <select id='counter_number' name="counter_number" class="form-control js-select2-custom change-counter">
                                                @if(count($counters) > 0)
                                                    @foreach($counters as $counter)
                                                        <option value="{{$counter->id}}" {{ session('counter_id') == $counter->id ? 'selected' : '' }}>{{ $counter->number }} ({{ $counter->name }})</option>
                                                    @endforeach
                                                    @else
                                                    <option value=""> {{\App\CPU\translate('No Counter Found')}}</option>
                                                @endif

                                            </select>
                                        </div>
                                    <div class="mb-2 text-right">
                                        <a class="text-primary text-decoration-underline" id="add_new_customer" type="button" data-toggle="modal" data-target="#add-customer"><i class="tio-add"></i>{{ \App\CPU\translate('Add New Customer') }}</a>
                                    </div>
                                    <div class="d-flex align-items-center gap-2 mb-3">
                                        <div class="flex-grow-1">
                                            <select id='customer' name="customer_id" class="form-control js-data-example-ajax customer-change">
                                                <option>{{\App\CPU\translate('--select-customer--')}}</option>
                                                <option value="0">{{\App\CPU\translate('walking_customer')}}</option>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="mb-3">
                                        <label class="card bg-soft-primary shadow-none border-0 mb-3">
                                            <div class="card-body text-dark fs-13 d-flex flex-column gap-2 py-2">
                                                <div class="d-flex flex-wrap align-items-center gap-2">
                                                    <img src="{{asset('public/assets/admin/img/fi-rr-user.svg')}}" alt="">
                                                    <span id="current_customer"></span>
                                                </div>
                                                <div class="customer-phone-section d-none">
                                                    <div class="d-flex flex-wrap align-items-center gap-2">
                                                        <img src="{{asset('public/assets/admin/img/phone-flip.svg')}}" alt="">
                                                        <span id="current_customer_phone"></span>
                                                    </div>
                                                </div>
                                                <div class="customer-wallet-section d-none">
                                                    <div class="d-flex flex-wrap align-items-center gap-2">
                                                        <img src="{{asset('public/assets/admin/img/wallet-icon.svg')}}" alt="">
                                                        <span id="current_customer_balance">{{ \App\CPU\translate('Wallet Balance') }}: <strong></strong></span>{{\App\CPU\Helpers::currency_symbol() }}
                                                    </div>
                                                </div>
                                            </div>
                                        </label>
                                    </div>

                                    <div class="d-flex align-items-center justify-content-between cart-section">

                                    </div>
                                </div>
                            </div>
                            <div class="text-center">
                                <div id="cartloader" class="d-none">
                                    <img width="50" src="{{asset('public/assets/admin/img/loader.gif')}}">
                                </div>
                            </div>
                            <div id="cart">
                                @include('admin-views.pos._cart',['cart_id'=>$cartId])
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        {{-- Hold Offcancvas --}}
        <div class="offcanvas-filter" id="offcanvasHoldMenu">
            <?php
                $sessionCart = session()->has('cart_name') ? session('cart_name') : [];
                $currentCard = session()->has('current_user') ? session('current_user') : '';

                foreach ($sessionCart as $key => $data) {
                    $cardDataItems = session()->has($data) ? session($data) : [];

                    if (count($cardDataItems) < 1) {
                        unset($sessionCart[$key]);
                    }
                    if ( $data == $currentCard) {
                        unset($sessionCart[$key]);
                    }
                }
            ?>
            <div class="offcanvas-filter__header">
                <h4>{{\App\CPU\translate('Hold_Orders')}} <span class="badge badge-danger ml-2">{{ count($sessionCart) }}</span></h4>
                <p>{{\App\CPU\translate('Your hold orders')}}</p>
                <div class="input-group-overlay input-group-merge input-group-custom">
                    <div class="input-group-prepend">
                        <div class="input-group-text">
                            <i class="tio-search"></i>
                        </div>
                    </div>
                    <input id="hold-order-search" autocomplete="off" type="text" name="search"
                        class="form-control search-bar-input"
                        placeholder="{{\App\CPU\translate('search_by_hold_id_or_customer_info')}}"
                        aria-label="Search here" >
                    <diV class="pos-search-card w-4 position-absolute z-index-1 w-100">
                        <div id="search-box" class="card card-body search-result-box d--none p-2"></div>
                    </diV>
                </div>
            </div>
            @if(count($sessionCart) > 0)
                <div class="offcanvas-filter__body pt-3">
                    <div class="hold-card">
                        @foreach($sessionCart as $index => $cart)
                            <div class="single-hold-card">
                                <a href="{{ route('admin.pos.cancel-hold-order', ['cart_id' => $cart]) }}"><i class="tio-clear-circle card_close_btn"></i></a>
                                <div class="px-4">
                                    <div class="d-flex justify-content-between align-items-center">
                                        <h5>{{\App\CPU\translate('Hold ID')}}: <strong>{{ $cart }}</strong></h5>
                                            <?php
                                            $userId = 0;
                                            $userType = 'wc';
                                            if (\Illuminate\Support\Str::contains($cart, 'sc')) {
                                                $userId = explode('-', $cart)[1];
                                                $userType = 'sc';
                                            }
                                            if ($userType == 'sc'){
                                                $cardCustomer = \App\Models\Customer::where(['id' => $userId])->first();
                                            }else{
                                                $cardCustomer = \App\Models\Customer::where(['id' => 0])->first();
                                            }
                                            ?>

                                        <div>
                                            <h6 class="mb-0 text-capitalize">{{$cardCustomer?->name}}</h6>
                                            @if($userType == 'sc')
                                                <a href="javascript:">{{$cardCustomer?->mobile}}</a>
                                            @endif
                                        </div>
                                    </div>
                                        <?php
                                        $cardItems = session()->has($cart) ? session($cart) : [];
                                        ?>

                                    <hr>
                                    <div class="d-flex justify-content-between align-items-center pb-4">
                                        <button type="button" class="btn text-primary hold-product-list-btn" id="hold_product_list_{{ $index }}">{{ count($cardItems) }} {{\App\CPU\translate('items')}}</button>
                                        <a type="button" class="btn btn-primary text-white" href="{{ route('admin.pos.change-cart', ['cart_id' => $cart]) }}">{{\App\CPU\translate('Resume')}}</a>
                                    </div>
                                </div>
                            </div>


                            <div class="table-container hidden mt-3" id="table_{{ $index }}">
                                <table class="table table-dark table-head-borderless table-nowrap table-align-middle mb-0">
                                    <thead>
                                    <th colspan="4" class="text-center text-white">{{\App\CPU\translate('Product_List')}}</th>
                                    </thead>
                                    <tbody id="set-rows">
                                    @foreach($cardItems as $item)
                                        <tr>
                                            <td>
                                                <a href="{{ route('admin.product.barcode-generate', [$item['id']]) }}" target="_blank">
                                                    <img class="img-one-cl" src="{{ asset('storage/app/public/product/' . $item['image']) }}" alt="">
                                                </a>
                                            </td>
                                            <td>
                                                <a class="text-white product-name" href="{{ route('admin.product.barcode-generate', [$item['id']]) }}" target="_blank">
                                                    {{ $item['name'] }}
                                                </a>
                                            </td>
                                            <td class="text-white">{{ $item['quantity'] }}</td>
                                            <td class="text-white">{{ $item['price'] }}</td>
                                        </tr>
                                    @endforeach
                                    </tbody>
                                </table>
                            </div>

                        @endforeach

                    </div>
                </div>
            @else
                <p class="text-center mt-10">{{ \App\CPU\translate('No Hold Orders') }}</p>
            @endif

            <div class="offcanvas-filter__footer bg-white py-2 d-flex align-items-center">
                <div class="d-flex justify-content-center align-items-center w-100">
                    <button type="button" class="btn btn-soft-primary mr-2 px-4" id="cancel_hold">{{\App\CPU\translate('Cancel')}}</button>
                </div>
            </div>
        </div>

        <div class="overlay" id="overlay"></div>

        {{-- Filter Offcancvas --}}
        <div class="offcanvas-filter filter-offcanvas" id="offcanvasFilterMenu">
            <div class="offcanvas-filter__header">
                <h4>{{\App\CPU\translate('Filter')}}</h4>
                <p>{{\App\CPU\translate('Filter to quickly find what you need.')}}</p>
            </div>
            <form action="{{ url()->current() }}" method="GET">
                <div class="offcanvas-filter__body">
                    <div class="mb-3">
                        <h6 class="pb-2">{{\App\CPU\translate('Price_Range')}}</h6>
                        <div class="range-slider">
                            <div class="track" id="rangeTrack"></div>
                            <input type="range" name="min_price" id="minPrice" min="{{ $minPrice }}" max="{{$maxPrice}}" value="{{ request('min_price', $minPrice) }}">
                            <input type="range" name="max_price" id="maxPrice" min="{{ $minPrice }}" max="{{ $maxPrice }}" value="{{ request('max_price', $maxPrice) }}">
                        </div>
                        <div class="price-range-info d-flex justify-content-between mt-2 gap-4">
                            <span class="form-control text-center">{{\App\CPU\translate('Min_Price')}}: <strong id="minPriceValue">{{request('min_price', $minPrice)}}</strong></span>
                            <span class="form-control text-center">{{\App\CPU\translate('Max_Price')}}: <strong id="maxPriceValue">{{request('max_price', $maxPrice)}}</strong></span>
                        </div>
                    </div>
                    <div class="mb-3">
                        <div class="d-flex justify-content-between">
                            <h6 class="pb-2">{{\App\CPU\translate('Category')}}</h6>
                            <div class="check-item">
                                <div class="form-group form-check form--check m-0">
                                    <input type="checkbox" id="categorySelectAll" class="form-check-input">
                                    <label for="categorySelectAll" class="form-check-label ml-2 text-dark">{{ \App\CPU\translate('Select All') }}</label>
                                </div>
                            </div>
                        </div>

                        <div class="row filter-cat" id="categoryFilter">
                            @foreach($categories as $category)
                                <div class="col-sm-6 d-flex">
                                    <label class="form-control mb-3 cursor-pointer ">
                                        <div class="check-item">
                                            <div class="d-flex form-group form-check form--check m-0">
                                                <input type="checkbox" name="category_ids[]" value="{{ $category->id }}" class="form-check-input category-checkbox"
                                                    {{ is_array(request('category_ids')) && in_array($category->id, request('category_ids')) ? 'checked' : '' }}>
                                                <span class=" align-content-center form-check-label line-limit-1 text-left ml-2 text-dark" title="{{ $category->name }}" >{{ $category->name }}</span>
                                            </div>
                                        </div>
                                    </label>
                                </div>
                            @endforeach
                        </div>
                        @if($categories->count() > 6)
                            <div class="text-center mb-2">
                                <button type="button" class="btn text-primary" id="see_more_category"><strong>{{\App\CPU\translate('See_more')}} <span>({{$categories->count() - 6}})</span></strong></button>
                            </div>
                        @endif
                    </div>

                    <!-- Subcategory filter -->
                    <div class="mb-3 {{ $subcategories->count() < 1 ? 'd-none' : '' }}" id="subcategory-section">
                        <div class="d-flex justify-content-between">
                            <h6 class="pb-2">{{\App\CPU\translate('Sub Category')}}</h6>
                            <div class="check-item">
                                <div class="form-group form-check form--check m-0">
                                    <input type="checkbox" id="subCategorySelectAll" class="form-check-input">
                                    <label for="subCategorySelectAll" class="form-check-label text-left ml-2 text-dark">{{ \App\CPU\translate('Select All') }}</label>
                                </div>
                            </div>
                        </div>
                        <div class="row filter-cat" id="subcategoryFilter">
                            <!-- Subcategories will be appended here dynamically -->
                            @foreach ($subcategories as $subcategory)
                                <div class="col-sm-6">
                                    <label class="form-control mb-3">
                                        <div class="check-item">
                                            <div class="d-flex form-group form-check form--check m-0">
                                                <input type="checkbox" name="subcategory_ids[]" value="{{ $subcategory->id }}" class="form-check-input subcategory-checkbox"
                                                    {{ is_array(request('subcategory_ids')) && in_array($subcategory->id, request('subcategory_ids')) ? 'checked' : '' }}>
                                                <span class=" align-content-center form-check-label line-limit-1 text-left ml-2 text-dark">{{ $subcategory->name }}</span>
                                            </div>
                                        </div>
                                    </label>
                                </div>
                            @endforeach
                        </div>
                            <div class="text-center mb-2 {{ $subcategories->count() <= 6 ? 'd-none' : '' }}" id="see_more_subcategory_btn">
                                <button type="button" class="btn text-primary" id="see_more_subcategory">
                                    <strong>{{\App\CPU\translate('See_more')}}<span id="more-sub-category-count"> ({{$subcategories->count() - 6}})</span></strong>
                                </button>
                            </div>
                    </div>

                    <div class="mb-3">
                        <div class="d-flex justify-content-between">
                            <h6 class="pb-2">{{\App\CPU\translate('Brand')}}</h6>
                            <div class="check-item">
                                <div class="form-group form-check form--check m-0">
                                    <input type="checkbox" id="brandSelectAll" class="form-check-input">
                                    <label for="brandSelectAll" class="form-check-label ml-2 text-dark">{{ \App\CPU\translate('Select All') }}</label>
                                </div>
                            </div>
                        </div>
                        <div class="row filter-cat" id="brandFilter">
                            @foreach($brands as $brand)
                                <div class="col-sm-6">
                                    <label class="form-control mb-3">
                                        <div class="check-item">
                                            <div class="d-flex form-group form-check form--check m-0">
                                                <input type="checkbox" name="brand_ids[]" value="{{ $brand->id }}" class="form-check-input brand-checkbox"
                                                    {{ is_array(request('brand_ids')) && in_array($brand->id, request('brand_ids')) ? 'checked' : '' }}>
                                                <span class="align-content-center form-check-label ml-2 text-dark line-limit-1" title="{{ $brand->name }}">{{ $brand->name }}</span>
                                            </div>
                                        </div>
                                    </label>
                                </div>
                            @endforeach
                        </div>
                        @if($brands->count() > 6)
                            <div class="text-center mb-2">
                                <button type="button" class="btn text-primary" id="see_more_brand"><strong>{{\App\CPU\translate('See_more')}} <span>({{$brands->count() - 6}})</span></strong></button>
                            </div>
                        @endif
                    </div>
                </div>
                <div class="offcanvas-filter__footer bg-white py-2 d-flex align-items-center">
                    <div class="d-flex justify-content-center align-items-center w-100">
                        <a href="{{ route('admin.pos.index') }}" class="btn btn-soft-primary mr-2 px-4" id="cancel_filter">{{\App\CPU\translate('Cancel')}}</a>
                        <button type="submit" class="btn btn-primary px-4">{{\App\CPU\translate('Apply')}}</button>
                    </div>
                </div>
            </form>
        </div>

        {{-- Product Details Modal --}}
        <div class="modal fade product-details-modal" id="productDetailsModal" tabindex="-1" aria-labelledby="productDetailsModalLabel" aria-hidden="true">
            <div class="modal-dialog">
                <div class="modal-content">

                    <button type="button" class="close position-absolute top-0 right-0 p-2" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">
                            <i class="tio-clear-circle"></i>
                        </span>
                    </button>
                    <div class="modal-body">
                        <div class="row">
                            <div class="col-md-4">
                                <div class="product-image d-flex justify-content-center align-items-center">
                                    <img src="{{asset('public/assets/admin/img/160x160/img2.jpg')}}" alt="{{\App\CPU\translate('product_image')}}">
                                </div>
                                <div class="mt-3">
                                    <h6>{{\App\CPU\translate('Categories')}}: <strong>{{\App\CPU\translate('Fruit')}}</strong></h6>
                                    <h6>{{\App\CPU\translate('Brands')}}: <strong>{{\App\CPU\translate('MyCompany')}}</strong></h6>
                                </div>
                            </div>
                            <div class="col-md-8">
                                <span class="badge badge-soft-success mb-2">
                                    <i class="tio-checkmark-circle-outlined"></i> {{\App\CPU\translate('In_Stock')}}: {{\App\CPU\translate('10')}}
                                </span>
                                <h4 class="mb-2">{{\App\CPU\translate('Fresh milk is a pure & safe cow milk product for the people.')}}</h4>
                                <h6><span>{{\App\CPU\translate('SKU')}} : {{\App\CPU\translate('JKDHGDKGH845')}}</span></h6>
                                <div class="d-flex align-items-center gap-2 mb-4">
                                    <span class="prev-price">{{\App\CPU\translate('$100.00')}}</span>
                                    <span class="new-price">{{\App\CPU\translate('$90.00')}}</span>
                                </div>
                                <div class="d-inline-block">
                                    <div class="d-flex align-items-center gap-3">
                                        <span class="qty">{{\App\CPU\translate('qty')}}</span>
                                        <div class="quantity">
                                            <button class="minus" aria-label="Decrease">&minus;</button>
                                            <input type="number" class="input-box" value="1" min="1" max="10">
                                            <button class="plus" aria-label="Increase">&plus;</button>
                                        </div>
                                        <button type="button" class="btn btn-primary add-to-cart">{{\App\CPU\translate('Add to Cart')}}</button>
                                    </div>
                                    <span class="total-price_btn w-100 mt-4">
                                        <span>{{\App\CPU\translate('Total Price')}}: </span><span class="text-primary">{{\App\CPU\translate('$ 20.0')}}</span> <span class="tax-text">({{\App\CPU\translate('Tax')}}: {{\App\CPU\translate('$ 2')}})</span>
                                    </span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="modal fade product-details-modal" id="quick-view" tabindex="-1" aria-hidden="true">
            <div class="modal-dialog">
                <div class="modal-content" id="quick-view-modal">

                </div>
            </div>
        </div>
        @php($order=\App\Models\Order::find(session('last_order')))
        @if($order)
            @php(session(['last_order'=> false]))
            <div class="modal fade" id="print-invoice" tabindex="-1">
                <div class="modal-dialog">
                    <div class="modal-content modal-content1">
                        <div class="modal-header">
                            <h5 class="modal-title">{{\App\CPU\translate('print_invoice')}}</h5>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                <span class="text-dark" aria-hidden="true">&times;</span>
                            </button>
                        </div>
                        <div class="modal-body row font-i1">
                            <div class="col-md-12">
                                <div class="text-center">
                                    <input id="print_invoice" type="button" class="mt-2 btn btn-primary non-printable print-div"
                                        data-name="printableArea"
                                        value="Proceed, If thermal printer is ready."/>
                                    <a id="invoice_close" data-route="{{url()->previous()}}"
                                    class="mt-2 btn btn-danger non-printable invoice-close">{{\App\CPU\translate('back')}}</a>
                                </div>
                                <hr class="non-printable">
                            </div>
                            <div class="row m-auto" id="printableArea">
                                @include('admin-views.pos.order.invoice')
                            </div>
                        </div>
                        </div>
                    </div>
                </div>
            </div>
        @endif
        <input type="hidden" id="seeMoreCategory" name="see-more-category" value="{{ $categories->count() - 6 }}">
        <input type="hidden" id="seeMoreBrand" name="see-more-brand" value="{{ $brands->count() - 6 }}">
        <input type="hidden" id="seeMoreSubcategory" name="see-more-subcategory" value="{{ $subcategories->count() - 6 }}">
        <input type="hidden" name="walking_customer" id="currentCustomer" value="{{\App\CPU\translate('walking_customer')}}">
    </main>

    <script src="{{asset('public/assets/admin')}}/js/custom.js"></script>

    <script src="{{asset('public/assets/admin')}}/js/vendor.min.js"></script>
    <script src="{{asset('public/assets/admin')}}/js/theme.min.js"></script>
    <script src="{{asset('public/assets/admin')}}/js/sweet_alert.js"></script>
    <script src="{{asset('public/assets/admin')}}/js/toastr.js"></script>
    <script src="{{asset('public/assets/admin')}}/plugins/swiper.min.js"></script>
    <script src="{{asset('public/assets/admin')}}/js/pos.js"></script>



{!! Toastr::message() !!}

@if ($errors->any())
    <script>
        "use strict";

        @foreach($errors->all() as $error)
        toastr.error('{{$error}}', Error, {
            CloseButton: true,
            ProgressBar: true
        });
        @endforeach
    </script>
@endif

<script>
    "use strict";

    function fullScreen() {
        var elem = document.documentElement;
        if (!document.fullscreenElement) {
            elem.requestFullscreen().catch(err => {
                alert(`Error attempting to enable full-screen mode: ${err.message} (${err.name})`);
            });
        } else {
            document.exitFullscreen();
        }
    }

    $(document).on('click', function(e) {
        if($(e.target).closest('.input-group-custom').length) {
            $('.search-result-box').css('display', 'block');
        } else if (!$(e.target).closest('.search-result-box').length) {
            $('.search-result-box').css('display', 'none');
        }
    });

    function handleDecrementButtonDisabled() {
        $('.counter-input').each(function(){
            if($(this).val()<=1) {
                $(this).siblings('.btn-decrement').attr('disabled', true);
            } else {
                $(this).siblings('.btn-decrement').attr('disabled', false);
            }
        })
    }

    $(document).ready(function(){
        handleDecrementButtonDisabled();
    })

    $(".empty-cart").on('click', function(){
        emptyCart();
    });

    $('.fullscreen-button').on('click', fullScreen)

    $(document).on('click', '#logoutLink', function(e) {
        e.preventDefault();

        Swal.fire({
            title: '{{\App\CPU\translate('Do you want to logout')}}?',
            showDenyButton: true,
            showCancelButton: true,
            confirmButtonColor: '#FC6A57',
            cancelButtonColor: '#363636',
            confirmButtonText: `{{\App\CPU\translate('Yes')}}`,
            denyButtonText: `{{\App\CPU\translate('Don\'t Logout')}}'`,
        }).then((result) => {
            if (result.value) {
                window.location.href = '{{route('admin.auth.logout')}}';
            } else {
                Swal.fire('{{\App\CPU\translate('Canceled')}}', '', '{{\App\CPU\translate('info')}}');
            }
        });
    });

    $(document).on('ready', function () {

        $(".print-div").on('click', function(){
            let divName = $(this).data('name');
            printDiv(divName);
        });

        $(".invoice-close").on('click', function(){
            window.location.href = $(this).data('route');
        });

        $('.category-show').on('change', function() {
            set_category_filter($(this).val());
        });

        $('.cart-change').on('change', function() {
            cart_change($(this).val());
        });

        $('.customer-change').on('change', function() {
            customer_change($(this).val());
        });
        $(".hover-content-text").on('click', function(){
            let product_id = $(this).closest('.single-cart-data').data('id');
            addToCart(product_id);
        });

        $('.js-hs-unfold-invoker').each(function () {
            var unfold = new HSUnfold($(this)).init();
        });

        $('.pos-search').focus();
        $.ajax({
            url: '{{route('admin.pos.get-cart-ids')}}',
            type: 'GET',

            dataType: 'json',
            beforeSend: function () {
                $('#loading').removeClass('d-none');
            },
            success: function (data) {
                var output = '';
                    for(var i=0; i<data.cart_nam.length; i++) {
                        output += `<option value="${data.cart_nam[i]}" ${data.current_user==data.cart_nam[i]?'selected':''}>${data.cart_nam[i]}</option>`;
                    }
                    $('#cart_id').html(output);
                    $('#current_customer').text(data.current_customer);
                    $('#current_customer_phone').text(data.current_customer_phone);
                    $('#current_customer_balance').text(data.current_customer_balance);
                    $('#cart').empty().html(data.view);
                    if(data.user_type === 'sc')
                    {
                        customer_Balance_Append(data.user_id);
                    }
            },
            complete: function () {
                $('#loading').addClass('d-none');
            },
        });
    });

    $(document).on('ready', function(){

        $(".direction-toggle").on("click", function () {
            setDirection(localStorage.getItem("direction"));
        });

        function setDirection(direction) {
            if (direction == "rtl") {
                localStorage.setItem("direction", "ltr");
                $("html").attr('dir', 'ltr');
            $(".direction-toggle").find('span').text('Toggle RTL')
            } else {
                localStorage.setItem("direction", "rtl");
                $("html").attr('dir', 'rtl');
            $(".direction-toggle").find('span').text('Toggle LTR')
            }
        }

        if (localStorage.getItem("direction") == "rtl") {
            $("html").attr('dir', "rtl");
            $(".direction-toggle").find('span').text('Toggle LTR')
        } else {
            $("html").attr('dir', "ltr");
            $(".direction-toggle").find('span').text('Toggle RTL')
        }

    })

    function payment_option(val) {
        if ($(val).val() != 1 && $(val).val() != 0) {
            $("#collected_cash").addClass('d-none');
            $("#returned_amount").addClass('d-none');
            $("#balance").addClass('d-none');
            $("#remaining_balance").addClass('d-none');
            $("#transaction_ref").removeClass('d-none');
            $('#cash_amount').attr('required',false);
        } else if ($(val).val() == 1) {
            $("#collected_cash").removeClass('d-none');
            $("#returned_amount").removeClass('d-none');
            $("#transaction_ref").addClass('d-none');
            $("#balance").addClass('d-none');
            $("#remaining_balance").addClass('d-none');

        } else if($(val).val() == 0){
            $("#balance").removeClass('d-none');
            $("#remaining_balance").removeClass('d-none');
            $("#collected_cash").addClass('d-none');
            $("#returned_amount").addClass('d-none');
            $("#transaction_ref").addClass('d-none');
            $('#cash_amount').attr('required',false);
            let customerId = $('#customer').val();
            $.ajax({
            url: '{{route('admin.pos.customer-balance')}}',
            type: 'GET',
            data: {
                customer_id: customerId
            },
            dataType: 'json',
            beforeSend: function () {
                $('#loading').removeClass('d-none');
            },
            success: function (data) {
                let balance = data.customer_balance;
                let order_total = $('#total_price').text();
                let remain_balance = parseInt(balance) - parseInt(order_total);
                $('#balance_customer').val(balance);
                $('#balance_remain').val(remain_balance);
            },
            complete: function () {
                $('#loading').addClass('d-none');
            },
        });
        }

    }

    function initializedCustomer(){
        $.ajax({
            url: '{{route('admin.pos.selected-customer')}}',
            type: 'GET',

            dataType: 'json',

            success: function (data) {
                if(data.user_type == 1){
                    let balance = data.current_customer_balance;
                    let order_total = $('#total_price').text();
                    let remain_balance = parseInt(balance) - parseInt(order_total);

                    $('.customer-phone-section').removeClass('d-none');
                    $('.customer-wallet-section').removeClass('d-none');

                    $('#current_customer').text(data.current_customer);
                    $('#current_customer_phone').text(data.current_customer_phone);
                    $('#current_customer_balance').text(data.current_customer_balance);

                    $('#balance_customer').val(balance);
                    $('#balance_remain').val(remain_balance);

                    $('#wallet-payment-section').removeClass('d-none')

                    $('#customer').append(`<option value="${data.customer_id}" selected>${data.current_customer}</option>`);

                }else {
                    $('#customer').append(`<option value="0" selected>${$('#currentCustomer').val()}</option>`);
                    $('#wallet-payment-section').addClass('d-none')
                }
            },

        });
    }
    initializedCustomer();

    function customer_change(val) {
        $.post({
                url: '{{route('admin.pos.remove-coupon')}}',
                data: {
                    _token: '{{csrf_token()}}',
                    user_id:val
                },
                beforeSend: function () {
                    $('#loading').removeClass('d-none');
                },
                success: function (data) {
                    var output = '';
                    for(var i=0; i<data.cart_nam.length; i++) {
                        output += `<option value="${data.cart_nam[i]}" ${data.current_user==data.cart_nam[i]?'selected':''}>${data.cart_nam[i]}</option>`;
                    }
                    $('#cart_id').html(output);
                    $('#current_customer').text(data.current_customer);

                    if(val == 0){
                        $('.customer-phone-section').addClass('d-none');
                        $('.customer-wallet-section').addClass('d-none');
                    }else {
                        $('.customer-phone-section').removeClass('d-none');
                        $('.customer-wallet-section').removeClass('d-none');
                        $('#current_customer_phone').text(data.current_customer_phone);
                        $('#current_customer_balance').text(data.current_customer_balance);
                    }

                    $('#cart').empty().html(data.view);
                    customer_Balance_Append(val);

                    if(val == 0){
                        $('#wallet-payment-section').addClass('d-none')

                    }else {
                        $('#wallet-payment-section').removeClass('d-none')
                    }
                },
                complete: function () {
                    $('#loading').addClass('d-none');
                }
            });
    }

    function cart_change(val)
    {
        let  cart_id = val;
        let url = "{{route('admin.pos.change-cart')}}"+'/?cart_id='+val;
        document.location.href=url;
    }

    function extra_discount()
    {
        let discount = $('#dis_amount').val();
        let type = $('#type_ext_dis').val();
        if(discount)
        {
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="_token"]').attr('content')
                }
            });
            $.post({
                url: '{{ route('admin.pos.discount') }}',
                data: {
                    _token: '{{csrf_token()}}',
                    discount:discount,
                    type:type,
                },
                beforeSend: function () {
                    $('#loading').removeClass('d-none');
                },
                success: function (data) {
                    if(data.extra_discount==='success')
                    {
                        toastr.success('{{ \App\CPU\translate('extra_discount_added_successfully') }}', {
                            CloseButton: true,
                            ProgressBar: true
                        });
                    }else if(data.extra_discount==='empty')
                    {
                        toastr.warning('{{ \App\CPU\translate('your_cart_is_empty') }}', {
                            CloseButton: true,
                            ProgressBar: true
                        });

                    }else{
                        toastr.warning('{{ \App\CPU\translate('this_discount_is_not_applied_for_this_amount') }}', {
                            CloseButton: true,
                            ProgressBar: true
                        });
                    }

                    $('.modal-backdrop').addClass('d-none');
                    $('#cart').empty().html(data.view);
                    if(data.user_type === 'sc')
                    {
                        customer_Balance_Append(data.user_id);
                    }
                    $('.pos-search').focus();
                    $('#dis_amount').val(discount);
                },
                complete: function () {
                    $('.modal-backdrop').addClass('d-none');
                    $(".footer-offset").removeClass("modal-open");
                    $('#loading').addClass('d-none');
                }
            });
        }
    }

    function coupon_discount()
    {
        let  coupon_code = $('#coupon_code').val();

        $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="_token"]').attr('content')
                }
            });
            $.post({
                url: '{{route('admin.pos.coupon-discount')}}',
                data: {
                    _token: '{{csrf_token()}}',
                    coupon_code:coupon_code,
                },
                beforeSend: function () {
                    $('#loading').removeClass('d-none');
                },
                success: function (data) {
                    if(data.coupon === 'success')
                    {
                        toastr.success('{{ \App\CPU\translate('coupon_added_successfully') }}', {
                            CloseButton: true,
                            ProgressBar: true
                        });
                    }else if(data.coupon === 'amount_low')
                    {
                        toastr.warning('{{ \App\CPU\translate('this_discount_is_not_applied_for_this_amount') }}', {
                            CloseButton: true,
                            ProgressBar: true
                        });
                    }else if(data.coupon === 'cart_empty')
                    {
                        toastr.warning('{{ \App\CPU\translate('your_cart_is_empty') }}', {
                            CloseButton: true,
                            ProgressBar: true
                        });
                    } else if (data.coupon === 'min_purchase' ) {
                        toastr.warning('{{ \App\CPU\translate('minimum_purchase_to_avail_this_coupon_is ')}} {{  \App\CPU\Helpers::currency_symbol() }}' + data.min_purchase, {
                            CloseButton: true,
                            ProgressBar: true
                        });
                    }
                    else {
                        toastr.warning('{{ \App\CPU\translate('coupon_is_invalid') }}', {
                            CloseButton: true,
                            ProgressBar: true
                        });
                    }

                    $('#cart').empty().html(data.view);
                    if(data.user_type === 'sc')
                    {
                        customer_Balance_Append(data.user_id);
                    }
                    $('.pos-search').focus();
                    $('#coupon_code').val(coupon_code);

                    $(".coupon-slider-button").each(function(){
                        if($(this).data('coupon')== coupon_code) {
                            $(this).addClass('active');
                        }
                    })

                },
                complete: function () {
                    $('.modal-backdrop').addClass('d-none');
                    $(".footer-offset").removeClass("modal-open");
                    $('#loading').addClass('d-none');

                }
            });

    }

    $(document).on('ready', function () {
        @if($order)
            $('#print-invoice').modal('show');
        @endif
    });

    function set_category_filter(id) {
        var nurl = new URL('{!!url()->full()!!}');
        nurl.searchParams.set('category_id', id);
        location.href = nurl;
    }

    $('#search-form').on('submit', function (e) {
        e.preventDefault();
        var keyword = $('#datatableSearch').val();
        var nurl = new URL('{!!url()->full()!!}');
        nurl.searchParams.set('keyword', keyword);
        location.href = nurl;
    });

    $('.pos-single-product-card').on('click', function (){
        let productId = $(this).data('id');
        quickView(productId);
    });


    function quickView(product_id) {
        $.ajax({
            url: '{{route('admin.pos.quick-view')}}',
            type: 'GET',
            data: {
                product_id: product_id
            },
            dataType: 'json',
            success: function (data) {
                $('#quick-view').modal('show');
                $('#quick-view-modal').empty().html(data.view);
            },
        });
    }

    function addToCart(form_id) {
        let productId = form_id;

        let productQty = $('#product_qty').val();
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="_token"]').attr('content')
                }
            });
            $.post({
                url: '{{ route('admin.pos.add-to-cart') }}',
                data: {
                    _token: '{{csrf_token()}}',
                    id:productId,
                    quantity:productQty,
                },
                success: function (data) {
                    if(data.qty==0)
                    {
                        toastr.warning('{{\App\CPU\translate('product_quantity_end!')}}', {
                            CloseButton: true,
                            ProgressBar: true
                        });
                        $('#product-id-'+productId).find('.pos-product-item').find('.counter-input').val(data.cart_quantity);
                        $('#product-id-'+productId).find('.pos-product-item').addClass('active');
                    }else{
                        toastr.success('{{\App\CPU\translate('item_has_been_added_in_your_cart!')}}', {
                        CloseButton: true,
                        ProgressBar: true
                    });
                        const prevValue = $('#product-id-'+productId).find('.pos-product-item').find('.counter-input').val();
                        $('#product-id-'+productId).find('.pos-product-item').find('.counter-input').val(parseInt(prevValue) + parseInt(productQty));
                        $('#product-id-'+productId).find('.pos-product-item').addClass('active');
                    }

                    $('#cart').empty().html(data.view);
                    if(data.user_type === 'sc')
                    {
                        customer_Balance_Append(data.user_id);
                    }
                    $('.pos-search').val('').focus();
                    $('#search-box').addClass('d-none');
                    handleDecrementButtonDisabled();
                },
                complete: function () {
                    $('#cartloader').addClass('d-none');

                }
            });

    }

    function removeFromCart(key) {
        $.post('{{ route('admin.pos.remove-from-cart') }}', {_token: '{{ csrf_token() }}', key: key}, function (data) {
                $('#cart').empty().html(data.view);
                if(data.user_type === 'sc')
                {
                    customer_Balance_Append(data.user_id);
                }
                toastr.info('{{\App\CPU\translate('item_has_been_removed_from_cart')}}', {
                    CloseButton: true,
                    ProgressBar: true
                });
            $('#single-product-card-' + key).find('.counter-input').val(0);
            $('#single-product-card-' + key).removeClass('active');
            $('#single-product-card-' + key + '.pos-product-item_thumb').addClass('single-cart-data');

            //location.reload();
            $('.pos-search').focus();

        });
    }

    function emptyCart() {
        Swal.fire({
            title: '{{\App\CPU\translate('Are_you_sure?')}}',
            text: '{{\App\CPU\translate('You_want_to_remove_all_items_from_cart!!')}}',
            type: 'warning',
            showCancelButton: true,
            cancelButtonColor: 'default',
            confirmButtonColor: '#161853',
            cancelButtonText: '{{\App\CPU\translate('No')}}',
            confirmButtonText: '{{\App\CPU\translate('Yes')}}',
            reverseButtons: true
        }).then((result) => {
            if (result.value) {
                $.post('{{ route('admin.pos.emptyCart') }}', {_token: '{{ csrf_token() }}'}, function (data) {
                    $('#cart').empty().html(data.view);
                    $('.pos-search').focus();
                    if(data.user_type === 'sc')
                    {
                        customer_Balance_Append(data.user_id);
                    }
                    toastr.info('{{\App\CPU\translate('Item_has_been_removed_from_cart')}}', {
                        CloseButton: true,
                        ProgressBar: true
                    });
                    location.reload()
                });

            }
        })

    }

    function updateCart() {
        $.post('<?php echo e(route('admin.pos.cart_items')); ?>', {_token: '<?php echo e(csrf_token()); ?>'}, function (data) {
            $('#cart').empty().html(data);
        });
    }

    // Increment functionality for the single product page
    $('.increment-decrement-section .btn-increment').click(function (){
        let container = $(this).closest('.increment-decrement-section');
        let input = container.find('.counter-input');
        let currentVal = parseInt(input.val());

        if (!isNaN(currentVal)) {
            input.val(currentVal + 1);
            updateQuantity(container.data('id'), input.val());
        }
    });

    // Decrement functionality for the single product page
    $('.increment-decrement-section .btn-decrement').click(function (){

        let container = $(this).closest('.increment-decrement-section');
        let input = container.find('.counter-input');
        let currentVal = parseInt(input.val());

        if (!isNaN(currentVal) && currentVal > 1) {
            input.val(currentVal - 1);
            updateQuantity(container.data('id'), input.val());
        }
    });

    // Manual input change handling for the single product page
    $('.increment-decrement-section .counter-input').on('input', function() {
        let input = $(this);
        let value = parseInt(input.val());

        if (isNaN(value) || value < 1) {
            input.val(1);
        }
        updateQuantity(input.closest('.increment-decrement-section').data('id'), input.val());
    });

    function updateQuantity(id,qty) {
        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="_token"]').attr('content')
            }
        });
        $.post({
            url: '{{ route('admin.pos.updateQuantity') }}',
            data: {
                _token: '{{csrf_token()}}',
                key: id,
                quantity: qty,
            },
            beforeSend: function () {
                $('#loading').removeClass('d-none');
            },
            success: function (data) {
                if(data.qty<0)
                {
                    toastr.warning('{{\App\CPU\translate('product_quantity_is_not_enough!')}}' + ' maximum quantity is ' + data.cart_quantity + '.', {
                        CloseButton: true,
                        ProgressBar: true
                    });
                }
                if(data.upQty==='zeroNegative')
                {
                    toastr.warning('{{\App\CPU\translate('Product_quantity_can_not_be_zero_or_less_than_zero_in_cart!')}}', {
                        CloseButton: true,
                        ProgressBar: true
                    });
                }
                $('.single_card_input_'+ id).val(data.cart_quantity);
                $('.pos-search').focus();
                $('#cart').empty().html(data.view);
                if(data.user_type === 'sc')
                {
                    customer_Balance_Append(data.user_id);
                }
                handleDecrementButtonDisabled();
            },
            complete: function () {
                $('#loading').addClass('d-none');
            }
        });



    }

    $('.js-select2-custom').each(function () {
        var select2 = $.HSCore.components.HSSelect2.init($(this));
    });

    $('.js-data-example-ajax').select2({
        ajax: {
            url: '{{route('admin.pos.customers')}}',
            data: function (params) {
                return {
                    q: params.term,
                    page: params.page
                };
            },
            processResults: function (data) {
                return {
                    results: data
                };
            },
            __port: function (params, success, failure) {
                var $request = $.ajax(params);

                $request.then(success);
                $request.fail(failure);

                return $request;
            }
        }
    });

    jQuery(".search-bar-input").on('keyup',function () {
        $(".search-card").removeClass('d-none').show();
        let name = $(".search-bar-input").val();
        if (name.length >0) {
            $('#search-box').removeClass('d-none').show();
            $.get({
                url: '{{route('admin.pos.search-products')}}',
                dataType: 'json',
                data: {
                    name: name
                },
                beforeSend: function () {
                    $('#loading').removeClass('d-none');
                },
                success: function (data) {
                    // if (data.count == 0) {
                    //     $('#search-box').addClass('d-none');
                    // }
                    $('.search-result-box').empty().html(data.result);
                },
                complete: function () {
                    $('#loading').addClass('d-none');
                },
            });
        } else {
            $('.search-result-box').empty();
            $('#search-box').addClass('d-none');
        }
    });

    jQuery(".search-bar-input").on('keyup',delay(function () {
        $(".search-card").removeClass('d-none').show();
        let name = $(".search-bar-input").val();
        if (name.length > 0 || isNaN(name)) {
            $.get({
                url: '{{route('admin.pos.search-by-add')}}',
                dataType: 'json',
                data: {
                    name: name
                },
                success: function (data) {
                    if (data.count == 1) {
                        $('.pos-search').attr("disabled", true);
                        addToCart(data.id);
                        $('.pos-search').attr("disabled", false);
                        $('.search-result-box').empty().html(data.result);
                        $('.pos-search').val('');
                        $('#search-box').addClass('d-none');
                    }
                },
            });
        } else {
            $('.search-result-box').empty();
        }
    },1000));


    $(document).ready(function () {
        if ($(".navbar-vertical-content li.active").length) {
            $('.navbar-vertical-content').animate({
                scrollTop: $(".navbar-vertical-content li.active").offset().top - 150
            }, 10);
        }
    });

    $(document).ready(function() {
        $(document).on('click', '.search-result-box .list-group-item', function() {
            $('.pos-search').val('');
            $('.search-result-box').addClass('d--none'); // Hide the results box
        });
        function fetchSubCategories() {
            $(document).on('change', '.category-checkbox', function() {
                $('#subCategorySelectAll').prop('checked', false);
                var selectedCategories = [];

                $('.category-checkbox:checked').each(function() {
                    selectedCategories.push($(this).val());
                });

                let allChecked = $('.category-checkbox').length > 0 && $('.category-checkbox:checked').length === $('.category-checkbox').length;
                $('#categorySelectAll').prop('checked', allChecked);

                $.ajax({
                    url: '{{ route("admin.pos.subcategories") }}',
                    method: 'GET',
                    data: {
                        category_ids: selectedCategories
                    },
                    success: function(response) {
                        let remainingSubcategories = response.subcategories.length - 6;
                        $('#seeMoreSubcategory').val(remainingSubcategories);
                        if (response.subcategories.length > 0) {
                            $('#subcategory-section').removeClass('d-none');
                            $('#subcategoryFilter').empty();

                            response.subcategories.forEach(function(subcategory) {
                                $('#subcategoryFilter').append(`
                            <div class="col-sm-6">
                                <label class="form-control mb-3">
                                    <div class="check-item">
                                        <div class="d-flex form-group form-check form--check m-0">
                                            <input type="checkbox" name="subcategory_ids[]" value="${subcategory.id}" class="form-check-input subcategory-checkbox">
                                            <span class="align-content-center form-check-label line-limit-1 text-left ml-2 text-dark" title="${subcategory.name}">${subcategory.name}</span>
                                        </div>
                                    </div>
                                </label>
                            </div>
                        `);
                            });

                            if (remainingSubcategories > 0) {
                                $('#see_more_subcategory_btn').removeClass('d-none');
                                $('#more-sub-category-count').text(` (${remainingSubcategories})`);
                                if ($('#see_more_subcategory').length && $('#subcategoryFilter').length) {
                                    if ($('#subcategoryFilter').hasClass('expanded')) {
                                        $('#see_more_subcategory').html('<strong>See less</strong>');
                                    } else {
                                        $('#see_more_subcategory').html(`<strong>See more <span>(${remainingSubcategories})</span></strong>`);
                                    }
                                }
                            } else {
                                $('#see_more_subcategory_btn').addClass('d-none');
                            }
                            $('#subCategorySelectAll').off('click').on('click', function() {
                                var isChecked = $(this).prop('checked');
                                $('.subcategory-checkbox').prop('checked', isChecked);

                                // Call toggleFilter only if the necessary elements exist
                                if ($('#see_more_subcategory').length && $('#subcategoryFilter').length && $('#seeMoreSubcategory').length) {
                                    if (!isChecked) {
                                        $('#subcategoryFilter').removeClass('expanded');
                                        $('#see_more_subcategory').html(`<strong> See more (${$('#seeMoreSubcategory').val()})</strong>`);
                                    } else {
                                        $('#subcategoryFilter').addClass('expanded');
                                        $('#see_more_subcategory').html('<strong>See less</strong>');
                                    }
                                }
                            });
                            $(document).on('change', '.subcategory-checkbox', function() {
                                let allChecked = $('.subcategory-checkbox').length > 0 && $('.subcategory-checkbox:checked').length === $('.subcategory-checkbox').length;
                                $('#subCategorySelectAll').prop('checked', allChecked);
                            });
                        } else {
                            $('#subcategory-section').addClass('d-none');
                        }
                    }
                });
            });
        }
        fetchSubCategories();

        function updateSelectAllCheckbox() {
            let allChecked = $('.category-checkbox').length > 0 && $('.category-checkbox:checked').length === $('.category-checkbox').length;
            $('#categorySelectAll').prop('checked', allChecked);
            if (allChecked) {
                $('#categoryFilter').addClass('expanded');
                $('#see_more_category').html('<strong>See less</strong>');
            } else {
                $('#categoryFilter').removeClass('expanded');
                $('#see_more_category').html(`<strong> See more (${$('#seeMoreCategory').val()})</strong>`);
            }
        }
        updateSelectAllCheckbox();

        function updateSelectAllSubcategoryCheckbox() {
            let allChecked = $('.subcategory-checkbox').length > 0 && $('.subcategory-checkbox:checked').length === $('.subcategory-checkbox').length;
            $('#subCategorySelectAll').prop('checked', allChecked);
            if (allChecked) {
                $('#subcategoryFilter').addClass('expanded');
                $('#see_more_subcategory').html('<strong>See less</strong>');
            } else {
                $('#subcategoryFilter').removeClass('expanded');
                $('#see_more_subcategory').html(`<strong> See more (${$('#seeMoreSubcategory').val()})</strong>`);
            }
        }
        updateSelectAllSubcategoryCheckbox();

        function updateSelectAllBrandCheckbox() {
            let allChecked = $('.brand-checkbox').length > 0 && $('.brand-checkbox:checked').length === $('.brand-checkbox').length;
            $('#brandSelectAll').prop('checked', allChecked);
            if (allChecked) {
                $('#brandFilter').addClass('expanded');
                $('#see_more_brand').html('<strong>See less</strong>');
            } else {
                $('#brandFilter').removeClass('expanded');
                $('#see_more_brand').html(`<strong> See more (${$('#seeMoreBrand').val()})</strong>`);
            }
        }
        updateSelectAllBrandCheckbox();

        $('#categorySelectAll').on('click', function(){
            var isChecked = $(this).prop('checked');
            $('.category-checkbox').prop('checked', isChecked);
            $('.category-checkbox').trigger('change');
            if (!isChecked) {
                $('#subCategorySelectAll').prop('checked', false);
                $('#categoryFilter').removeClass('expanded');
                $('#see_more_category').html(`<strong> See more (${$('#seeMoreCategory').val()})</strong>`);
            } else {
                $('#categoryFilter').addClass('expanded');
                $('#see_more_category').html('<strong>See less</strong>');
            }
        })

        $('#subCategorySelectAll').off('click').on('click', function() {
            var isChecked = $(this).prop('checked');
            $('.subcategory-checkbox').prop('checked', isChecked);

            // Call toggleFilter only if the necessary elements exist
            if ($('#see_more_subcategory').length && $('#subcategoryFilter').length && $('#seeMoreSubcategory').length) {
                if (!isChecked) {
                    $('#subcategoryFilter').removeClass('expanded');
                    $('#see_more_subcategory').html(`<strong> See more (${$('#seeMoreSubcategory').val()})</strong>`);
                } else {
                    $('#subcategoryFilter').addClass('expanded');
                    $('#see_more_subcategory').html('<strong>See less</strong>');
                }
            }
        });

        $(document).on('change', '.subcategory-checkbox', function() {
            let allChecked = $('.subcategory-checkbox').length > 0 && $('.subcategory-checkbox:checked').length === $('.subcategory-checkbox').length;
            $('#subCategorySelectAll').prop('checked', allChecked);
        });

        $('#brandSelectAll').on('click', function(){
            var isChecked = $(this).prop('checked');
            $('.brand-checkbox').prop('checked', isChecked);
            if (!isChecked) {
                $('#brandFilter').removeClass('expanded');
                $('#see_more_brand').html(`<strong> See more (${$('#seeMoreBrand').val()})</strong>`);
            } else {
                $('#brandFilter').addClass('expanded');
                $('#see_more_brand').html('<strong>See less</strong>');
            }
        })

        $(document).on('change', '.brand-checkbox', function() {
            let allChecked = $('.brand-checkbox').length > 0 && $('.brand-checkbox:checked').length === $('.brand-checkbox').length;
            $('#brandSelectAll').prop('checked', allChecked);
        });

        // filter category show / hide
        function toggleFilter(buttonId, filterId, valueId) {
            console.log('toggle')
            const button = document.getElementById(buttonId);
            const filter = document.getElementById(filterId);
            const value = document.getElementById(valueId);

            filter.classList.toggle('expanded');

            if (filter.classList.contains('expanded')) {
                button.innerHTML = '<strong>See less</strong>';
            } else {
                button.innerHTML = `<strong>See more <span>(${value.value})</span></strong>`;
            }
        }

        const seeMoreCategory = document.getElementById('see_more_category');
        if (seeMoreCategory) {
            seeMoreCategory.addEventListener('click', function() {
                toggleFilter('see_more_category', 'categoryFilter', 'seeMoreCategory');
            });
        }


        const seeMoreSubcategory = document.getElementById('see_more_subcategory');
        if (seeMoreSubcategory) {
            seeMoreSubcategory.addEventListener('click', function() {
                toggleFilter('see_more_subcategory', 'subcategoryFilter', 'seeMoreSubcategory');
            });
        }

        const seeMoreBrand = document.getElementById('see_more_brand');
        if (seeMoreBrand) {
            seeMoreBrand.addEventListener('click', function() {
                toggleFilter('see_more_brand', 'brandFilter', 'seeMoreBrand');
            });
        }
    });
</script>
<script src="{{asset('public/assets/admin')}}/js/app-page.js"></script>
<script>
    "use strict";

    // JavaScript to toggle the off-canvas menu
    $('#filterMenuToggle').on('click', function () {
        $('#offcanvasFilterMenu').toggleClass('open');
        $('#overlay').toggleClass('active');
    });

    $('#holdMenuToggle').on('click', function () {
        $('#offcanvasHoldMenu').toggleClass('open');
        $('#overlay').toggleClass('active');
    });

    $('#overlay').on('click', function () {
        $('#offcanvasFilterMenu').removeClass('open');
        $('#offcanvasHoldMenu').removeClass('open');
        $(this).removeClass('active');
    });

    document.getElementById('cancel_filter').addEventListener('click', function() {
        $('#offcanvasFilterMenu').removeClass('open');
        $('#overlay').removeClass('active');
    });

    document.getElementById('cancel_hold').addEventListener('click', function() {
        $('#offcanvasHoldMenu').removeClass('open');
        $('#overlay').removeClass('active');
    });


    // Min-max range slider
    const minPrice = document.getElementById('minPrice');
    const maxPrice = document.getElementById('maxPrice');
    const minPriceValue = document.getElementById('minPriceValue');
    const maxPriceValue = document.getElementById('maxPriceValue');
    const rangeTrack = document.getElementById('rangeTrack');

    function updateTrackBackground() {
        const minVal = parseInt(minPrice.value);
        const maxVal = parseInt(maxPrice.value);
        const minPercent = (minVal / minPrice.max) * 100;
        const maxPercent = (maxVal / maxPrice.max) * 100;

        rangeTrack.style.insetInlineStart = `${minPercent}%`;
        rangeTrack.style.width = `${maxPercent - minPercent}%`;
    }

    function updatePriceValues() {
        minPriceValue.textContent = `${minPrice.value} {{\App\CPU\Helpers::currency_symbol() }}`;
        maxPriceValue.textContent = `${maxPrice.value} {{\App\CPU\Helpers::currency_symbol() }}`;
    }

    minPrice.addEventListener('input', function () {
        if (parseInt(minPrice.value) >= parseInt(maxPrice.value)) {
        minPrice.value = maxPrice.value - 1;
        }
        updatePriceValues();
        updateTrackBackground();
    });

    maxPrice.addEventListener('input', function () {
        if (parseInt(maxPrice.value) <= parseInt(minPrice.value)) {
        maxPrice.value = parseInt(minPrice.value) + 1;
        }
        updatePriceValues();
        updateTrackBackground();
    });

    updatePriceValues();
    updateTrackBackground();

    // Hold card table show / hide
    document.addEventListener("DOMContentLoaded", function() {
        let currentlyOpenTable = null;

        const productButtons = document.querySelectorAll('.hold-product-list-btn');

        productButtons.forEach(button => {
            button.addEventListener('click', function(event) {
                event.stopPropagation();

                const index = this.id.split('_').pop();
                const tableId = 'table_' + index;
                const table = document.getElementById(tableId);

                // const tableId = 'table_' + this.id.split('_')[3];
                // const table = document.getElementById(tableId);

                if (currentlyOpenTable && currentlyOpenTable !== table) {
                    currentlyOpenTable.classList.add('hidden');
                }

                table.classList.toggle('hidden');

                currentlyOpenTable = table.classList.contains('hidden') ? null : table;
            });
        });

        document.addEventListener('click', function(event) {
            if (currentlyOpenTable && !currentlyOpenTable.contains(event.target)) {
                currentlyOpenTable.classList.add('hidden');
                currentlyOpenTable = null;
            }
        });
    });


    // Quatity button
    (function () {
        const quantityContainer = document.querySelector(".quantity");
        const minusBtn = quantityContainer.querySelector(".minus");
        const plusBtn = quantityContainer.querySelector(".plus");
        const inputBox = quantityContainer.querySelector(".input-box");

        updateButtonStates();

        quantityContainer.addEventListener("click", handleButtonClick);
        inputBox.addEventListener("input", handleQuantityChange);

        function updateButtonStates() {
            const value = parseInt(inputBox.value);
            minusBtn.disabled = value <= 1;
            plusBtn.disabled = value >= parseInt(inputBox.max);
        }

        function handleButtonClick(event) {
            if (event.target.classList.contains("minus")) {
            decreaseValue();
            } else if (event.target.classList.contains("plus")) {
            increaseValue();
            }
        }

        function decreaseValue() {
            let value = parseInt(inputBox.value);
            value = isNaN(value) ? 1 : Math.max(value - 1, 1);
            inputBox.value = value;
            updateButtonStates();
            handleQuantityChange();
        }

        function increaseValue() {
            let value = parseInt(inputBox.value);
            value = isNaN(value) ? 1 : Math.min(value + 1, parseInt(inputBox.max));
            inputBox.value = value;
            updateButtonStates();
            handleQuantityChange();
        }

        function handleQuantityChange() {
            let value = parseInt(inputBox.value);
            value = isNaN(value) ? 1 : value;
        }
    })();

    $('.change-counter').on('change', function() {
        let counterId = $(this).val()
        $.post({
            url: '{{route('admin.pos.change-counter')}}',
            data: {
                _token: '{{csrf_token()}}',
                counter_id: counterId
            },
            beforeSend: function () {
                $('#loading').removeClass('d-none');
            },
            success: function (data) {

            },
            complete: function () {
                $('#loading').addClass('d-none');
            }
        });
    });

    $(document).ready(function() {
        $('#hold-order-search').on('keyup', function() {
            var searchTerm = $(this).val().toLowerCase();

            $('.single-hold-card').each(function() {
                var holdId = $(this).find('h5 strong').text().toLowerCase();
                var customerName = $(this).find('h6').text().toLowerCase();
                var customerMobile = $(this).find('a').text().toLowerCase();

                if (holdId.includes(searchTerm) || customerName.includes(searchTerm) || customerMobile.includes(searchTerm)) {
                    $(this).show();
                } else {
                    $(this).hide();
                }
            });
        });
    });

</script>

    <script>
        function printFilterCount() {
            let currentUrl = new URL(window.location.href);
            let params = currentUrl.searchParams;
            let filteredParams = Array.from(params.keys()).filter(param =>
                !['type', 'search', 'start_date', 'end_date', 'page'].includes(param)
            );
            let hasPriceRange = filteredParams.includes('min_price') &&  filteredParams.includes('max_price');
            if (hasPriceRange) {
                filteredParams = filteredParams.filter(param => param !== 'min_price' && param !== 'max_price');
                filteredParams.push('price_range');
            }
            let paramCount = filteredParams.length;
            if (paramCount > 0) {
                $('.show-filter-count').append('<span class="position-absolute badge badge-primary filter-count">' + paramCount + '</span>');
            } else {
                $('.show-filter-count').find('.filter-count').remove();
            }
        }

        printFilterCount();
    </script>

@stack('script_2')


</body>
</html>
