@extends('layouts.admin.app')

@section('title', \App\CPU\translate('counter setup'))

@push('css_or_js')
    <link rel="stylesheet" href="{{ asset('public/assets/admin') }}/css/custom.css" />
@endpush

@section('content')
    <div class="content container-fluid">
        <div class="">
            <div class="row align-items-center mb-3 ">
                <div class="col-sm mb-2 mb-sm-0">
                    <h1 class="page-header-title text-capitalize fs-16">
                        <span>{{ \App\CPU\translate('counter setup') }}</span>
                    </h1>
                </div>
            </div>
        </div>
        <div class="card">
            <div class="card-body">
                <form action="{{ route('admin.counter.store') }}" method="post">
                    @csrf
                    <div class="row pl-2">
                        <div class="col-12 col-sm-6">
                            <div class="form-group mb-3">
                                <label class="input-label font-weight-medium text-capitalize" for="name">{{ \App\CPU\translate('Counter_Name') }}</label>
                                <input type="text" name="name" class="form-control" value="{{ old('name') }}" maxlength="255"
                                    placeholder="{{ \App\CPU\translate('Ex: Fast Lanee') }}" required>
                            </div>
                            <div class="form-group mb-3">
                                <label class="input-label font-weight-medium text-capitalize" for="number">{{ \App\CPU\translate('Counter_number') }}</label>
                                <input type="text" name="number" class="form-control" value="{{ old('number') }}"
                                    placeholder="{{ \App\CPU\translate('Ex: 01') }}" required>
                            </div>
                        </div>
                        <div class="col-12 col-sm-6">
                            <div class="form-group mb-3">
                                <label class="input-label font-weight-medium text-capitalize" for="description">{{ \App\CPU\translate('Short_Description') }}</label>
                                <textarea class="form-control" name="description" id="" cols="30" rows="5" required maxlength="255">{{ old('description') }}</textarea>
                            </div>
                        </div>
                    </div>
                    <div class="d-flex justify-content-end pt-1">
                        <button type="reset" class="btn btn-secondary mr-2 min-w-80px" href="javascript:">{{ \App\CPU\translate('reset') }}</button>
                        <button type="submit" class="btn btn-primary min-w-80px">{{ \App\CPU\translate('submit') }}</button>
                    </div>
                </form>
            </div>
        </div>
        <div class="card mt-3">
            <div class="card-header">
                <div class="w-100">
                    <div class="row">
                        <div class="col-12 col-sm-4 col-md-6 col-lg-7 col-xl-8">
                            <h5>{{ \App\CPU\translate('counter_list') }}
                                <span class="badge badge-soft-dark">{{$counters->total()}}</span>
                            </h5>
                        </div>
                        <div class=" col-12 col-sm-8 col-md-6 col-lg-5 col-xl-4">
                            <form action="{{ url()->current() }}" method="GET">
                                <div class="input-group input-group-merge input-group-flush">
                                    <div class="input-group-prepend">
                                        <div class="input-group-text">
                                            <i class="tio-search"></i>
                                        </div>
                                    </div>
                                    <input id="datatableSearch_" type="search" name="search" class="form-control"
                                           placeholder="{{ \App\CPU\translate('search_by_counter_name_or_number') }}"
                                           aria-label="Search orders" value="{{ $queryParam['search'] ?? '' }}" required>
                                    <button type="submit"
                                            class="btn btn-primary">{{ \App\CPU\translate('search') }}</button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>

            <div class="table-responsive datatable-custom counter-table">
                <table
                    class="table table-borderless table-thead-bordered table-nowrap table-align-middle card-table">
                    <thead class="thead-light">
                        <tr>
                            <th>{{ \App\CPU\translate('Serial_no') }}</th>
                            <th>{{ \App\CPU\translate('Counter_Name') }}</th>
                            <th class="text-center">{{ \App\CPU\translate('Counter_Number') }}</th>
                            <th>{{ \App\CPU\translate('status') }}</th>
                            <th class="text-center">{{ \App\CPU\translate('action') }}</th>
                        </tr>
                    </thead>

                    <tbody id="set-rows">
                    @foreach($counters as $key => $counter)
                        <tr>
                            <td>{{ $counters->firstitem()+$key }}</td>
                            <td>
                                <span class="d-block font-size-sm text-body">{{ $counter->name }}</span>
                            </td>
                            <td class="text-center">{{ $counter->number }}</td>
                            <td>
                                <label class="toggle-switch toggle-switch-sm">
                                    <input type="checkbox" class="toggle-switch-input change-status"
                                           data-route="{{ route('admin.counter.status',[$counter['id'],$counter->status?0:1]) }}"
                                           class="toggle-switch-input" {{$counter->status?'checked':''}}>
                                    <span class="toggle-switch-label">
                                                <span class="toggle-switch-indicator"></span>
                                            </span>
                                </label>
                            </td>
                            <td>
                                <div class="d-flex justify-content-center gap-2">
                                    <div class="d-inline">
                                        <a class="btn btn-white mr-1" data-toggle="tooltip" data-placement="top" title="" href="{{ route('admin.counter.details', [$counter['id']]) }}" data-original-title="view">
                                            <span class="tio-visible"></span>
                                        </a>
                                    </div>
                                    <div class="d-inline">
                                        <a class="btn btn-white mr-1" href="{{ route('admin.counter.edit', [$counter['id']]) }}"> <span class="tio-edit"></span></a>
                                    </div>
                                    <div class="d-inline">
                                        <a class="btn btn-white mr-1 form-alert" href="javascript:" data-id="counter-{{ $counter['id'] }}" data-message="Want to delete this counter?"><span class="tio-delete"></span></a>
                                    </div>
                                    <form action="{{ route('admin.counter.delete', [$counter['id']]) }}"
                                          method="post" id="counter-{{ $counter['id'] }}">
                                        @csrf @method('delete')
                                    </form>
                                </div>
                            </td>
                        </tr>
                    @endforeach
                    </tbody>
                </table>
                <div class="card-footer">
                    <div class="row justify-content-center justify-content-sm-end align-items-sm-center">
                        <div class="col-sm-auto">
                            <div class="d-flex justify-content-center justify-content-sm-end">
                                {!! $counters->links() !!}
                            </div>
                        </div>
                    </div>
                </div>
                @if (count($counters) == 0)
                    <div class="text-center p-4">
                        <img class="mb-3 w-one-cati"
                             src="{{ asset('public/assets/admin') }}/svg/illustrations/sorry.svg"
                             alt="Image Description">
                        <p class="mb-0">{{ \App\CPU\translate('No_data_to_show') }}</p>
                    </div>
                @endif
            </div>
        </div>
    </div>
@endsection

@push('script_2')
    <script src={{ asset('public/assets/admin/js/global.js') }}></script>
@endpush
